; -------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob Strikes Back - Work Areas
; ------------------------------------------------------------------------------------------------------------- ;
; Score Key Buffer
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_ScoreKeyBuffer      = $f000 ; 
BB_WA_ScoreKeyBufferLen     = $07 ; 
; ------------------------------------------------------------------------------------------------------------- ;
; Intro Birds Area Map
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Birds               = $f000                                    ; 
BB_WA_Birds_Len             = $15                                    ; 
BB_WA_Birds_Max             = $08                                    ; $08 birds = $08 WAs * $15 bytes each
BB_WA_BirdsSpriteNum      = [BB_WA_Birds + $00]                      ; 
BB_WA_BirdsPosX           = [BB_WA_Birds + $01]                      ; 
BB_WA_BirdsPosY           = [BB_WA_Birds + $02]                      ; 
BB_WA_BirdsSpriteNumVIC   = [BB_WA_Birds + $03]                      ; 
BB_WA_BirdsDrop           = [BB_WA_Birds + $04]                      ; 
BB_WA_BirdsDropNone         = $00                                    ; 
BB_WA_BirdsDropChar         = $80                                    ; 
BB_WA_BirdsDropBlank        = $03                                    ; 
BB_WA_BirdsSpriteNumPtr   = [BB_WA_Birds + $05]                      ; 
BB_WA_BirdsWaitAction     = [BB_WA_Birds + $06]                      ; 
BB_WA_BirdsStatus         = [BB_WA_Birds + $07]                      ; 
BB_WA_BirdsStatusSit        = $00                                    ; 
BB_WA_BirdsStatusDrop       = $01                                    ; 
BB_WA_BirdsStatusReturn     = $02                                    ; 
BB_WA_BirdsStatusSupply     = $03                                    ; 
BB_WA_BirdsAdjustPosX     = [BB_WA_Birds + $08]                      ; 
BB_WA_BirdsAdjustPosY     = [BB_WA_Birds + $09]                      ; 
BB_WA_BirdsLandPosX       = [BB_WA_Birds + $0a]                      ; 
BB_WA_BirdsLandPosY       = [BB_WA_Birds + $0b]                      ; 
BB_WA_BirdsLandPosY_Ini     = $33                                    ; 
BB_WA_BirdsFlyDirX        = [BB_WA_Birds + $0c]                      ; 
BB_WA_BirdsFlyDirY        = [BB_WA_Birds + $0d]                      ; 
BB_WA_BirdsLandStepY      = [BB_WA_Birds + $0e]                      ; 
BB_WA_BirdsLandStepX      = [BB_WA_Birds + $0f]                      ; 
BB_WA_BirdsTxtPtrRnd      = [BB_WA_Birds + $10]                      ; 
BB_WA_BirdsTxtChrRnd      = [BB_WA_Birds + $11]                      ; 
BB_WA_BirdsFlyType        = [BB_WA_Birds + $12]                      ; 
BB_WA_BirdsFlyTypeSupply    = $00                                    ; 
BB_WA_BirdsFlyTypeReturn    = $01                                    ; 
BB_WA_BirdsAproachTime    = [BB_WA_Birds + $13]                      ; approach landing/fetch position
BB_WA_BirdsAproachTimeIni   = $03                                    ; approach landing/fetch position
BB_WA_BirdsSitWaitTime    = [BB_WA_Birds + $14]                      ; 
                                                                     ; $f0a8
; ------------------------------------------------------------------------------------------------------------- ;
; Floor Work Area Map - max $40
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Floor             = $f000                                      ; 
BB_WA_Floor_Len           = $04                                      ; 
BB_WA_Floor_Max           = $40                                      ; 
BB_WA_FloorPosY         = [BB_WA_Floor + [BB_WA_Floor_Max   * $00]]  ; $f000 - sort crit - descending
BB_WA_FloorMinX         = [BB_WA_Floor + [BB_WA_Floor_Max   * $01]]  ; $f040
BB_WA_FloorMaxX         = [BB_WA_Floor + [BB_WA_Floor_Max   * $02]]  ; $f080
BB_WA_FloorTileNum      = [BB_WA_Floor + [BB_WA_Floor_Max   * $03]]  ; $f0c0
                                                                     ; $f100
; ------------------------------------------------------------------------------------------------------------- ;
; Slide Work Area Map - max $32
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Slide             = $f290                                      ; 
BB_WA_Slide_Len           = $04                                      ; 
BB_WA_Slide_Max           = $32                                      ; 
BB_WA_SlideMid            = [BB_WA_Slide_Max / $02]                  ; 
BB_WA_SlidePosX         = [BB_WA_Slide  + [BB_WA_Slide_Max  * $00]]  ; $f290
BB_WA_SlidePosY         = [BB_WA_Slide  + [BB_WA_Slide_Max  * $01]]  ; $f2c2
BB_WA_SlideLen          = [BB_WA_Slide  + [BB_WA_Slide_Max  * $02]]  ; $f2f4
BB_WA_SlideMove         = [BB_WA_Slide  + [BB_WA_Slide_Max  * $03]]  ; $f326
BB_WA_SlideMoveDo         = $00                                      ; 
BB_WA_SlideMoveDoRi       = $01                                      ; 
BB_WA_SlideMoveDoLe       = $ff                                      ; 
                                                                     ; $f358
; ------------------------------------------------------------------------------------------------------------- ;
; Level Move Limit Work Area Map - max $0a
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_MoveLimit         = $f358                                      ; 
BB_WA_MoveLimit_Len       = $06                                      ; 
BB_WA_MoveLimit_Max       = $0a                                      ; 
BB_WA_MoveLimitPosX     = [BB_WA_MoveLimit + [BB_WA_MoveLimit_Max * $00]] ; $f358
BB_WA_MoveLimitMinX       = [BB_WA_MoveLimitPosX + $00]              ; $f358
BB_WA_MoveLimitMaxX       = [BB_WA_MoveLimitPosX + $01]              ; $f359
BB_WA_MoveLimitMinY     = [BB_WA_MoveLimit + [BB_WA_MoveLimit_Max * $01]] ; $f362
BB_WA_MoveLimitMinY0      = [BB_WA_MoveLimitMinY + $00]              ; $f362
BB_WA_MoveLimitMinY1      = [BB_WA_MoveLimitMinY + $01]              ; $f36c
BB_WA_MoveLimitMaxY     = [BB_WA_MoveLimit + [BB_WA_MoveLimit_Max * $02]] ; $f362
BB_WA_MoveLimitMaxY0      = [BB_WA_MoveLimitMaxY + $00]              ; $f362
BB_WA_MoveLimitMaxY1      = [BB_WA_MoveLimitMaxY + $01]              ; $f36c
                                                                     ; f394
; ------------------------------------------------------------------------------------------------------------- ;
; Floating Platform Work Area Map - max $0a
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Float             = $f394                                      ; 
BB_WA_Float_Len1          = BB_WA_Floor_Len                          ; 
BB_WA_Float_Len2          = $08                                      ; 
BB_WA_Float_Max           = $0a                                      ; 

BB_WA_FloatPosY         = [BB_WA_Floor  + [BB_WA_Floor_Max  * $00]]  ; $f000
BB_WA_FloatMinX         = [BB_WA_Floor  + [BB_WA_Floor_Max  * $01]]  ; $f040
BB_WA_FloatMaxX         = [BB_WA_Floor  + [BB_WA_Floor_Max  * $02]]  ; $f080
BB_WA_FloatTileNum      = [BB_WA_Floor  + [BB_WA_Floor_Max  * $03]]  ; $f0c0
                                                                   
BB_WA_FloatMoveSpeed    = [BB_WA_Float  + [BB_WA_Float_Max  * $00]]  ; $f394
BB_WA_FloatMoveSpeedDec = [BB_WA_Float  + [BB_WA_Float_Max  * $01]]  ; $f39e
BB_WA_FloatMoveDir      = [BB_WA_Float  + [BB_WA_Float_Max  * $02]]  ; $f3a8
BB_WA_FloatTileLen      = [BB_WA_Float  + [BB_WA_Float_Max  * $03]]  ; $f3b2
BB_WA_FloatType         = [BB_WA_Float  + [BB_WA_Float_Max  * $04]]  ; $f3bc
BB_WA_FloatMaskSpeed      = %00000111 ; .....SSS
BB_WA_FloatFlagDir        = %00001000 ; ....D... bit3=1 - move right / bit3=0 - move left
BB_WA_FloatTypeBiDir      = %00000000 ; $10 - perpetual  : turn around at MinX/MaxX
BB_WA_FloatTypeBiDirRND   = %00010000 ; $10 - perpetual  : turn around at MinX/MaxX - get a random initial move dir
BB_WA_FloatTypeOneDir     = %00100000 ; $20 - perpetual  : restart at MinX/MaxX if MaxX/MinX
BB_WA_FloatTypeStopMax    = %01000000 ; $40 - stop & wait: at MinX/MaxX on leave
BB_WA_FloatTypeStopIme    = %10000000 ; $80 - stop & wait: immediately  on leave
BB_WA_FloatTypeGraLift    = %11000000 ; $c0 - gravity lift

BB_WA_FloatMoveMinX     = [BB_WA_Float  + [BB_WA_Float_Max  * $05]]  ; $f3c6
BB_WA_FloatMoveMaxX     = [BB_WA_Float  + [BB_WA_Float_Max  * $06]]  ; $f3d0
BB_WA_FloatMoveHeight   = [BB_WA_Float  + [BB_WA_Float_Max  * $07]]  ; $f3da
                                                                     ; $f3e4
; ------------------------------------------------------------------------------------------------------------- ;
; Suction Tubes Area Map - max $05
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Tube              = $f3e4                                      ; 
BB_WA_Tube_Len            = $08                                      ; 
BB_WA_Tube_Max            = $05                                      ; 
BB_WA_TubeLeftPosY      = [BB_WA_Tube + [BB_WA_Tube_Max * $00]]      ; $f3e4
BB_WA_TubeRightPosX     = [BB_WA_Tube + [BB_WA_Tube_Max * $01]]      ; $f3e9
BB_WA_TubeLeftLen       = [BB_WA_Tube + [BB_WA_Tube_Max * $02]]      ; $f3ee
BB_WA_TubeRightLen      = [BB_WA_Tube + [BB_WA_Tube_Max * $03]]      ; $f3f3
BB_WA_TubeSwitchDir     = [BB_WA_Tube + [BB_WA_Tube_Max * $04]]      ; $f3f8
BB_WA_TubeSwitchVal       = $40                                      ; 
BB_WA_TubeSwitchDirOff    = [BB_WA_TubeSwitchVal * $01]              ; $40
BB_WA_TubeSwitchDirLe     = [BB_WA_TubeSwitchVal * $02]              ; $80
BB_WA_TubeSwitchDirRi     = [BB_WA_TubeSwitchVal * $03]              ; $c0
BB_WA_TubeSwitchPosX    = [BB_WA_Tube + [BB_WA_Tube_Max * $05]]      ; $f3fd
BB_WA_TubeSwitchPosY    = [BB_WA_Tube + [BB_WA_Tube_Max * $06]]      ; $f402
BB_WA_TubeLeftPosX      = [BB_WA_Tube + [BB_WA_Tube_Max * $07]]      ; $f407
                                                                     ; $f40c
; ------------------------------------------------------------------------------------------------------------- ;
; Pulverizator Work Area Map - max $0a
; ------------------------------------------------------------------------------------------------------------- ;
BB_Pulver               = $f40c                                      ; 
BB_Pulver_Len             = $03                                      ; 
BB_Pulver_Max             = $0a                                      ; 
BB_WA_PulverMovPos      = [BB_Pulver + [BB_Pulver_Max * $00]]        ; $f40c
BB_WA_PulverMovDir      = [BB_Pulver + [BB_Pulver_Max * $01]]        ; $f416
BB_WA_PulverMovDirUp      = $ff                                      ; -1
BB_WA_PulverMovDirDo      = $01                                      ; +1
BB_WA_PulverMovTimer    = [BB_Pulver + [BB_Pulver_Max * $02]]        ; $f420
BB_WA_PulverMovTimerIni   = $37                                      ; 
                                                                     ; $f42a
; ------------------------------------------------------------------------------------------------------------- ;
; Item Work Area Map - max $5e
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Acid              = $f42a                                      ; 
BB_WA_Acid_Len            = $04                                      ; 
BB_WA_Acid_Max            = $06                                      ; 
BB_WA_AcidDrop_Max        = [BB_WA_Acid_Len * BB_WA_Acid_Max]        ; $18
BB_WA_AcidDropHeadPosY  = [BB_WA_Acid + [BB_WA_AcidDrop_Max * $00]]  ; $f42a
BB_WA_AcidDropTailPosY  = [BB_WA_Acid + [BB_WA_AcidDrop_Max * $01]]  ; $f442
BB_WA_AcidDropPosYMin     = $03                                      ; 
BB_WA_AcidDropPosYMax     = $bc                                      ; 
BB_WA_AcidDropTailCover = [BB_WA_Acid + [BB_WA_AcidDrop_Max * $02]]  ; $f45a
BB_WA_AcidDropHeadCover = [BB_WA_Acid + [BB_WA_AcidDrop_Max * $03]]  ; $f472
                                                                     ; $f48a
; ------------------------------------------------------------------------------------------------------------- ;
; Item Work Area Map - max $5e/$28
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_ItemData          = $f784                                      ; 
BB_WA_ItemData_Len        = $05                                      ; 
BB_WA_ItemData_Max        = $5e                                      ; 
BB_WA_ItemDataCols      = [BB_WA_ItemData + [BB_WA_ItemData_Max * $00]] ; $f784
BB_WA_ItemDataRows      = [BB_WA_ItemData + [BB_WA_ItemData_Max * $01]] ; $f7e2
BB_WA_ItemDataPtrLo     = [BB_WA_ItemData + [BB_WA_ItemData_Max * $02]] ; $f840
BB_WA_ItemDataPtrHi     = [BB_WA_ItemData + [BB_WA_ItemData_Max * $03]] ; $f89e
BB_WA_ItemDataScore     = [BB_WA_ItemData + [BB_WA_ItemData_Max * $04]] ; $f8fc
                                                                     ; $f95a
BB_WA_Item              = $1e36                                      ; 
BB_WA_Item_Len            = $05                                      ; 
BB_WA_Item_Max            = $28                                      ; 
BB_WA_ItemPosX          = [BB_WA_Item + [BB_WA_Item_Max * $00]]      ; $1e36
BB_WA_ItemPosY          = [BB_WA_Item + [BB_WA_Item_Max * $01]]      ; $1e5e
BB_WA_ItemNo            = [BB_WA_Item + [BB_WA_Item_Max * $02]]      ; $1e86
BB_WA_ItemMaxX          = [BB_WA_Item + [BB_WA_Item_Max * $03]]      ; $1eae
BB_WA_ItemMaxY          = [BB_WA_Item + [BB_WA_Item_Max * $04]]      ; $1ed6
                                                                     ; $1efe
; -------------------------------------------------------------------------------------------------------------- ;
; High Score Work Area Map - max $0a + $01 (work)
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Score             = $1d88                                      ; 
BB_WA_Score_Len           = [BB_WA_ScoreEntryLen * BB_WA_Score_Max]  ; $8c
BB_WA_Score_LenMax        = [BB_WA_Score_Len + BB_WA_ScoreEntryLen]  ; $9a
BB_WA_Score_Max           = $0a                                      ; 
BB_WA_ScoreEntryLen       = $0e                                      ; 
BB_WA_ScoreNameLen        = [BB_WA_ScoreEntryLen / $02]              ; 
BB_WA_ScoreScoreLen       = [BB_WA_ScoreEntryLen / $02]              ; 
BB_WA_ScoreName         = [BB_WA_Score + [BB_WA_ScoreNameLen * $00]] ; 
BB_WA_ScoreScore        = [BB_WA_Score + [BB_WA_ScoreNameLen * $01]] ; 

BB_WA_ScoreWork         = [BB_WA_Score + BB_WA_Score_Len - $01]      ; $1e14
                                                                     ; $1e22
; ------------------------------------------------------------------------------------------------------------- ;
; Ladder Work Area Map - max $32
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Ladder              = $1efe                                    ; 
BB_WA_LadderMax             = $32                                    ; 
BB_WA_LadderPosX          = BB_WA_Ladder + BB_WA_LadderMax * $00     ; $1efe
BB_WA_LadderTopY          = BB_WA_Ladder + BB_WA_LadderMax * $01     ; $1f30
BB_WA_LadderLen           = BB_WA_Ladder + BB_WA_LadderMax * $02     ; $1f62
BB_WA_LadderAddX          = BB_WA_Ladder + BB_WA_LadderMax * $03     ; $1f94
BB_WA_LadderBotY          = BB_WA_Ladder + BB_WA_LadderMax * $04     ; $1fc6
                                                                     ; $1ff8
; ------------------------------------------------------------------------------------------------------------- ;
; Level Time Work Area Map - max $32
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_LevelTime           = $1ff8                                    ; 
BB_WA_LevelTimeLen          = $03                                    ; 
BB_WA_LevelTimeHi         = BB_WA_LevelTime                          ; 
BB_WA_LevelTimesHi_1000   = BB_WA_LevelTimeHi + $00                  ; $1ff8
BB_WA_LevelTimesHi_100    = BB_WA_LevelTimeHi + $01                  ; $1ff9
BB_WA_LevelTimesHi_10     = BB_WA_LevelTimeHi + $02                  ; $1ffa
BB_WA_LevelTimeLo         = BB_WA_LevelTimeHi + BB_WA_LevelTimeLen   ; 
BB_WA_LevelTimesLo_1000   = BB_WA_LevelTimeLo + $00                  ; $1ffb
BB_WA_LevelTimesLo_100    = BB_WA_LevelTimeLo + $01                  ; $1ffc
BB_WA_LevelTimesLo_10     = BB_WA_LevelTimeLo + $02                  ; $1ffd
                                                                     ; $1ffe
; -------------------------------------------------------------------------------------------------------------- ;
; Sprite Work Area Map - max $10
; ------------------------------------------------------------------------------------------------------------- ;
BB_WA_Sprite              = $f100                                     ; 
BB_WA_Sprite_Len            = $19                                     ; 
BB_WA_Sprite_Max            = $10                                     ; 
BB_WA_SpriteRaster        = [BB_WA_Sprite + [BB_WA_Sprite_Max * $00]] ; 
; -------------------------------------------------------------------------------------------------------------- ;
BB_WA_SpritePosX          = $e7e0                                     ; 
BB_WA_SpritePosX_P1       = [BB_WA_SpritePosX + [BB_WA_Sprite_Max * $00]] ; $e7e0
BB_WA_SpritePosX_P2       = [BB_WA_SpritePosX + [BB_WA_Sprite_Max * $01]] ; $e7f0
; -------------------------------------------------------------------------------------------------------------- ;
BB_WA_SpritePosY          = [BB_WA_Sprite + [BB_WA_Sprite_Max * $01]] ; 
BB_WA_SpritePosY_P1       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $01]] ; $f110
BB_WA_SpritePosY_P2       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $02]] ; $f120
                          
BB_WA_SpriteDir           = [BB_WA_Sprite + [BB_WA_Sprite_Max * $03]] ; 
BB_WA_SpriteDir_P1        = [BB_WA_Sprite + [BB_WA_Sprite_Max * $03]] ; $f130
BB_WA_SpriteDir_P2        = [BB_WA_Sprite + [BB_WA_Sprite_Max * $04]] ; $f140
                          
BB_WA_SpriteMinX          = [BB_WA_Sprite + [BB_WA_Sprite_Max * $05]] ; 
BB_WA_SpriteMinX_P1       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $05]] ; $f150
BB_WA_SpriteMinX_P2       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $06]] ; $f160
                          
BB_WA_SpriteMoveType      = [BB_WA_Sprite + [BB_WA_Sprite_Max * $05]] ; $f150 -> level 24 - mutants on the move
BB_WA_SpriteMoveTypeGr      = %00000000 ; ground
BB_WA_SpriteMoveTypeGrLe    = %01000000 ; ground/left
BB_WA_SpriteMoveTypeGrRi    = %10000000 ; ground/right
BB_WA_SpriteMoveTypeSl      = %00000000 ; slide             
BB_WA_SpriteMoveTypeSlSW    = %00000001 ; slide/South-West
BB_WA_SpriteMoveTypeSlNW    = %01000001 ; slide/NorthWest
BB_WA_SpriteMoveTypeSlSE    = %10000001 ; slide/South-East
BB_WA_SpriteMoveTypeSlNE    = %11000001 ; slide/North-East 
BB_WA_SpriteMoveTypeLa      = %00000010 ; ladder
BB_WA_SpriteMoveTypeLaDo    = %00000010 ; ladder/Down
BB_WA_SpriteMoveTypeLaUp    = %01000010 ; ladder/Up

BB_WA_SpriteMaxX          = [BB_WA_Sprite + [BB_WA_Sprite_Max * $07]] ; 
BB_WA_SpriteMaxX_P1       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $07]] ; $f170
BB_WA_SpriteMaxX_P2       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $08]] ; $f180
                          
BB_WA_SpriteTrip          = [BB_WA_Sprite + [BB_WA_Sprite_Max * $09]] ; $f190 -> level 24 - mutants on the move
                          
BB_WA_SpriteSpeedA        = [BB_WA_Sprite + [BB_WA_Sprite_Max * $09]] ; 
BB_WA_SpriteSpeedA_P1     = [BB_WA_Sprite + [BB_WA_Sprite_Max * $09]] ; $f190
BB_WA_SpriteSpeedA_P2     = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0a]] ; $f1a0
                          
BB_WA_SpriteSpeedB        = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0b]] ; 
BB_WA_SpriteSpeedB_P1     = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0b]] ; $f1b0
BB_WA_SpriteSpeedB_P2     = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0c]] ; $f1c0
                          
BB_WA_SpriteID            = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0d]] ; 
BB_WA_SpriteID_P1         = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0d]] ; $f1d0
BB_WA_SpriteID_P2         = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0e]] ; $f1e0
                          
BB_WA_SpriteColor         = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0f]] ; 
BB_WA_SpriteColor_P1      = [BB_WA_Sprite + [BB_WA_Sprite_Max * $0f]] ; $f1f0
BB_WA_SpriteColor_P2      = [BB_WA_Sprite + [BB_WA_Sprite_Max * $10]] ; $f200
                          
BB_WA_SpriteColorSave     = [BB_WA_Sprite + [BB_WA_Sprite_Max * $11]] ; $f210
                          
BB_WA_SpriteNumberA       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $13]] ; 
BB_WA_SpriteNumberA_P1    = [BB_WA_Sprite + [BB_WA_Sprite_Max * $13]] ; $f230
BB_WA_SpriteNumberA_P2    = [BB_WA_Sprite + [BB_WA_Sprite_Max * $14]] ; $f240
                          
BB_WA_SpriteNumberB       = [BB_WA_Sprite + [BB_WA_Sprite_Max * $15]] ; 
BB_WA_SpriteNumberB_P1    = [BB_WA_Sprite + [BB_WA_Sprite_Max * $15]] ; $f250
BB_WA_SpriteNumberB_P2    = [BB_WA_Sprite + [BB_WA_Sprite_Max * $16]] ; $f260
                          
BB_WA_SpritePtrA          = [BB_WA_Sprite + [BB_WA_Sprite_Max * $17]] ; $f270
BB_WA_SpritePtrB          = [BB_WA_Sprite + [BB_WA_Sprite_Max * $18]] ; $f280
                                                                      ; $f290
; -------------------------------------------------------------------------------------------------------------- ;
; Xmitter Work Area Map - max $05
; -------------------------------------------------------------------------------------------------------------- ;
BB_WA_Xmit                = $f376 ; 
BB_WA_Xmit_Max              = $05 ; 
BB_WA_XmitGamePosX        = [BB_WA_Xmit + [BB_WA_Xmit_Max * $00]]     ; $f376
BB_WA_XmitGamePosY        = [BB_WA_Xmit + [BB_WA_Xmit_Max * $01]]     ; $f37b
BB_WA_XmitDrawHeight      = [BB_WA_Xmit + [BB_WA_Xmit_Max * $02]]     ; $f380
BB_WA_XmitDrawHeightMax     = $23 ; 
BB_WA_XmitDrawHeightTop     = TabDrawXmitDataTopRows                  ; $0e
BB_WA_XmitDrawHeightWall    = TabDrawXmitDataWallRows                 ; $0b
;BB_WA_XmitDrawHeightTop     = $0e ; 
;BB_WA_XmitDrawHeightWall    = $0b ; 
BB_WA_XmitDrawDataPtr     = [BB_WA_Xmit + [BB_WA_Xmit_Max * $03]]     ; $f385
BB_WA_XmitDrawBits        = [BB_WA_Xmit + [BB_WA_Xmit_Max * $04]]     ; $f38a
BB_WA_XmitDrawBitsInit      = $80 ;
BB_WA_XmitDrawBitsTop       = $08 ;
BB_WA_XmitDrawBitsWall      = $05 ;
BB_WA_XmitDrawBitsTopRow    = [[BB_WA_XmitDrawBitsTop  * $02] - $01]  ; 
BB_WA_XmitDrawBitsWallRow   = [[BB_WA_XmitDrawBitsWall * $02] - $03]  ; 
BB_WA_XmitDrawBits_01       = [BB_WA_XmitDrawBits + $00]              ; $f38a
BB_WA_XmitDrawBits_02       = [BB_WA_XmitDrawBits + $01]              ; $f38b
BB_WA_XmitDrawBits_03       = [BB_WA_XmitDrawBits + $02]              ; $f38c
BB_WA_XmitDrawBits_04       = [BB_WA_XmitDrawBits + $03]              ; $f38d
BB_WA_XmitDrawBits_05       = [BB_WA_XmitDrawBits + $04]              ; $f38e
BB_WA_XmitDrawDataByte    = [BB_WA_Xmit + [BB_WA_Xmit_Max * $05]]     ; $f38f
; -------------------------------------------------------------------------------------------------------------- ;
; Score Work Area Map - max $01
; -------------------------------------------------------------------------------------------------------------- ;
BB_WA_Scores              = $f95a                                     ; 
BB_WA_Scores_Max            = $01                                     ; 
BB_WA_Scores_Len            = $0e                                     ; 
BB_WA_Scores_LenAdd         = $05                                     ; 
BB_WA_Scores_P1           = [BB_WA_Scores + $00]                           ; $f95a
BB_WA_Scores_P1_Len         = $07                                     ; 
BB_WA_Scores_P1_Off_10      = $05                                     ; no ones to score
BB_WA_Scores_P1_1000000   = [BB_WA_Scores + $00]                      ; $f95a
BB_WA_Scores_P1_100000    = [BB_WA_Scores + $01]                      ; $f95b
BB_WA_Scores_P1_10000     = [BB_WA_Scores + $02]                      ; $f95c
BB_WA_Scores_P1_1000      = [BB_WA_Scores + $03]                      ; $f95d
BB_WA_Scores_P1_100       = [BB_WA_Scores + $04]                      ; $f95e
BB_WA_Scores_P1_10        = [BB_WA_Scores + $05]                      ; $f95f
BB_WA_Scores_P1_1         = [BB_WA_Scores + $06]                      ; $f960

BB_WA_Scores_P2           = [BB_WA_Scores + $07]                      ; $f961
BB_WA_Scores_P2_Len         = $07                                     ; 
BB_WA_Scores_P2_Off_10      = $0c                                     ; no ones to score
BB_WA_Scores_P2_1000000   = [BB_WA_Scores + $07]                      ; $f961
BB_WA_Scores_P2_100000    = [BB_WA_Scores + $08]                      ; $f962
BB_WA_Scores_P2_10000     = [BB_WA_Scores + $09]                      ; $f963
BB_WA_Scores_P2_1000      = [BB_WA_Scores + $0a]                      ; $f964
BB_WA_Scores_P2_100       = [BB_WA_Scores + $0b]                      ; $f965
BB_WA_Scores_P2_10        = [BB_WA_Scores + $0c]                      ; $f966
BB_WA_Scores_P2_1         = [BB_WA_Scores + $0d]                      ; $f967

BB_WA_ScoresToAdd         = $f6b0                                     ; 
BB_WA_ScoresToAdd_1000000 = [BB_WA_ScoresToAdd + $00]                 ; $f6b0
BB_WA_ScoresToAdd_100000  = [BB_WA_ScoresToAdd + $01]                 ; $f6b1
BB_WA_ScoresToAdd_10000   = [BB_WA_ScoresToAdd + $02]                 ; $f6b2
BB_WA_ScoresToAdd_1000    = [BB_WA_ScoresToAdd + $03]                 ; $f6b3
BB_WA_ScoresToAdd_100     = [BB_WA_ScoresToAdd + $04]                 ; $f6b4
BB_WA_ScoresToAdd_10      = [BB_WA_ScoresToAdd + $05]                 ; $f6b5
; -------------------------------------------------------------------------------------------------------------- ;
